

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Jan 12 12:17:37 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief RSA ATP test vectors
   *
   *  \version CRYS_Ext_ATP_RSA_Acceptance_test_vectors.c#1:csrc:1
   *  \author annag
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
   
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */   
   
/***************************
 * File Name:                                                           
 *  CRYS_ATP_TST_RSA_Acceptance_test_vectors.c      
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for RCA Acceptance tests                              
 *
 **************************/


/***** Include Files ******/
#include "CRYS_error.h"
#include "CRYS_Ext_ATP_RSA_Acceptance.h"
#include "CRYS_Ext_ATP_RSA_Acceptance_test_vectors.h"

/******** Defines ************/
/******** Enums ************/
/******** Typedefs ***********/
/******** Global Data **********/
/***** Private function prototype **********/
/******** Public Functions *********/
/******** Private Functions ********/
SEP_RSA_TestDataStruct SEP_RSA_Acceptance_Primitive_TestData[] =
{
    { 
        {"Acceptance test - RSA 2048bit "},
        /*TST_PrivetExponent_D*/
        {0x0c,0x5b,0xc0,0x19,0x59,0xe7,0xcf,0x70,0x62,0xf8,0x19,0xa6,0xc9,0xcc,0xa4,0x6a,
         0xcd,0x12,0x0b,0x30,0xda,0xfc,0x68,0x51,0x18,0xc4,0x87,0x06,0x57,0x8f,0xaf,0x97,
         0x6f,0x96,0x20,0xa9,0x83,0x1c,0xb2,0x69,0xc4,0xaf,0xe6,0xf3,0x9f,0x23,0xf9,0x92,
         0x41,0x7c,0x83,0xd2,0x73,0xfb,0xe9,0xa7,0x5d,0x55,0xe7,0xb4,0xd7,0x13,0xb0,0x17,
         0xce,0x40,0xbb,0x14,0xe0,0x93,0x1f,0xb2,0x2c,0xf1,0x1f,0x01,0x86,0x2f,0x3d,0x22,
         0xa4,0x47,0xbb,0x9d,0x02,0x39,0xae,0x9d,0x1a,0x1f,0xed,0x4a,0xf3,0xc4,0x17,0xa8,
         0x05,0x8b,0x3d,0x04,0x62,0x99,0x91,0x91,0x3f,0xac,0x1f,0x15,0xb3,0x9f,0x06,0x1b,
         0x05,0xe9,0xa6,0x4f,0xec,0xc8,0x35,0x9d,0xc3,0x8f,0x82,0x26,0xc8,0x6e,0x94,0x8c,
         0x8a,0x29,0x42,0x10,0x91,0x72,0xf7,0x6c,0xe3,0xb0,0x07,0x0b,0x2f,0xff,0x33,0x84,
         0xc3,0x5a,0xc2,0x13,0x15,0xd3,0xe2,0xdb,0x98,0x2f,0x44,0xba,0x34,0xcb,0xbe,0x63,
         0x6b,0x73,0x36,0xe5,0x27,0x11,0x70,0x6d,0x7a,0xb2,0x74,0x34,0xb6,0x8f,0xe9,0x09,
         0x57,0x67,0xc8,0x50,0x1c,0x7e,0x7b,0xe6,0xd4,0xb8,0xaf,0x7c,0xbe,0x2d,0x16,0x0f,
         0x76,0x44,0x3a,0xfe,0x8d,0x6d,0xc8,0xec,0xa9,0xd5,0x48,0x1f,0xbb,0x85,0x50,0x3f,
         0xef,0xbd,0x8b,0xfd,0x9f,0xf1,0xb8,0x00,0x09,0x67,0x49,0x74,0xc5,0xe9,0xf2,0xd5,
         0x26,0xf1,0x93,0x59,0x73,0xf7,0x84,0x98,0xa5,0xa3,0x25,0xbe,0x73,0xc8,0x1c,0xb4,
         0x1c,0xef,0xbb,0x20,0x59,0x4f,0x3a,0x74,0x92,0xda,0x15,0x76,0xa4,0x12,0xb0,0x21},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xb5,0x84,0x8f,0x09,0xa3,0x94,0xac,0x97,0x25,0x17,0x54,0x46,0x6c,0x49,0xcb,0x69,
         0xff,0x21,0x68,0x03,0x1b,0xb9,0xf6,0xe8,0x14,0x84,0xa2,0xa5,0x62,0x39,0x8d,0xe4,
         0x2f,0x22,0xc8,0x53,0xc0,0x8e,0x9a,0x5c,0x6f,0x2b,0xb2,0xa2,0x24,0x77,0x60,0xa1,
         0x47,0xa5,0x6c,0xd5,0xe0,0x77,0x33,0x7a,0xd5,0xf5,0xf6,0x4a,0x0e,0x7d,0x06,0xbd,
         0xb2,0x3b,0x83,0xef,0xaf,0xad,0x65,0xda,0xdb,0xd0,0x7d,0xea,0x09,0x73,0xf8,0x4e,
         0x1b,0xe7,0xaa,0xe6,0x84,0x57,0xb6,0xf3,0x88,0xf3,0xb0,0x4d,0x2b,0xa9,0xe8,0x23,
         0xa3,0xee,0x3f,0x16,0xd0,0x08,0x80,0x38,0x11,0x4a,0x66,0x3a,0xad,0x14,0x68,0xc4,
         0x37,0xce,0x36,0x7a,0xf4,0xe0,0x95,0x0d,0xf3,0xae,0x2b,0x46,0xb7,0xac,0x4a,0x8a,
         0xa0,0xe1,0x78,0xd1,0x38,0xa9,0x36,0xdb,0x3d,0xde,0x04,0xa2,0x35,0x79,0x1f,0xc5,
         0x13,0x39,0xf8,0x5b,0xf3,0x5a,0xb5,0xcb,0xf9,0x8f,0x1c,0xf8,0xad,0x09,0x0f,0x03,
         0x04,0xf3,0xcc,0x02,0x4c,0xa8,0x6d,0xe1,0x0a,0x3f,0x71,0x75,0x69,0xf4,0xd3,0xe6,
         0xa8,0x2c,0x92,0x0b,0xb5,0x6d,0x7d,0xf9,0x61,0x68,0x42,0xd7,0xbe,0xde,0x32,0x9f,
         0xfb,0x7a,0x23,0x2d,0xc5,0x22,0x3d,0x90,0xc3,0x38,0x12,0x5e,0xb0,0x9b,0xc0,0x5c,
         0x7b,0x5d,0x4f,0x7a,0xec,0x65,0xb6,0xe1,0x24,0xfa,0x00,0x15,0xe3,0x5e,0x4f,0x80,
         0x2e,0x79,0xe7,0x29,0xdc,0x4d,0xa2,0x15,0x68,0xe7,0x83,0xc9,0x40,0xfc,0x89,0xa9,
         0x6a,0x47,0xff,0xbc,0x39,0x6d,0x0a,0x75,0xe1,0x6e,0x17,0x39,0x5f,0x1e,0x4f,0xdf},
        /*TST_P*/
        {0xf1,0x4b,0x87,0x28,0x1c,0xbf,0x5e,0x14,0xeb,0x6d,0x33,0x42,0x80,0x95,0xe4,0xd5,
         0x58,0xa8,0xa7,0x1a,0xf9,0xae,0x93,0xc7,0xba,0x00,0x31,0x02,0x5c,0x49,0xa8,0xa1,
         0x04,0x36,0xa9,0x35,0x6d,0xc8,0x25,0x7e,0x79,0x96,0x2a,0xca,0x3a,0x13,0xd5,0x3f,
         0xa6,0xf8,0x04,0xd0,0xf1,0x5a,0xf3,0x8d,0x6e,0x09,0xdb,0x25,0x3d,0x3c,0xe2,0x72,
         0xce,0x88,0x66,0xca,0xf3,0x3d,0x70,0x96,0x96,0xf1,0xef,0x45,0xde,0x11,0x4e,0x6a,
         0xb6,0x5d,0x9d,0xd4,0xdd,0x3e,0x16,0xb2,0x54,0xcc,0xf8,0xbe,0x6a,0x02,0x2d,0x73,
         0x8e,0x4a,0xa7,0x49,0xc0,0xb9,0xc2,0x26,0x93,0xd4,0x03,0xff,0x27,0x3a,0x57,0xa7,
         0xed,0xfd,0xdf,0x20,0xdb,0x7e,0x47,0xed,0x32,0xb5,0x20,0x8e,0xd4,0x1f,0xb6,0x07},
        /*TST_Q*/
        {0xc0,0x94,0x70,0x77,0x38,0xdb,0x39,0x48,0xf4,0x69,0x16,0x7f,0x16,0x66,0x69,0xde,
         0xb2,0x37,0xf6,0x62,0x24,0x88,0x2d,0x85,0x64,0xaf,0xcd,0x3d,0x7c,0x5a,0xb2,0xf7,
         0x86,0xf4,0xc4,0xaf,0xd7,0x7f,0x94,0x86,0x2f,0xd1,0x9d,0x77,0x0c,0x45,0x89,0x31,
         0xd2,0xab,0x19,0xea,0x48,0x39,0xfd,0xaa,0xae,0x6f,0x08,0x08,0x03,0x13,0x03,0x7e,
         0x83,0x23,0x01,0x30,0x6b,0xfa,0xb2,0x71,0xec,0xd2,0x79,0x8e,0xcd,0x6e,0x93,0x26,
         0x35,0x98,0x52,0x92,0x36,0x34,0xd3,0x24,0xfa,0xab,0xc6,0x46,0xdf,0x36,0xae,0xc7,
         0xca,0x5e,0x9f,0x83,0xe3,0xfc,0x08,0x50,0x77,0xe9,0xe1,0xb0,0xff,0x90,0x5e,0x0e,
         0x3e,0x38,0x73,0xe8,0x91,0x04,0xeb,0x65,0x26,0x98,0x5b,0x7c,0xab,0xbc,0x61,0x69},     
        /*TST_dP*/
        {0x12,0x47,0xbb,0x8c,0x91,0x68,0xfa,0x12,0xb1,0xa7,0x4b,0x3b,0xdd,0x8b,0xfd,0x93,
         0x20,0x2d,0x5e,0xc3,0x8f,0x68,0xe7,0x6f,0x39,0x2b,0x2c,0x8b,0x56,0x3c,0x8a,0x56,
         0xf0,0x7f,0xc7,0x9f,0xf1,0x9a,0x39,0x24,0xf4,0xc7,0x28,0xa4,0xbb,0x73,0xa7,0x33,
         0x34,0x4e,0x13,0xe7,0x54,0x71,0xa4,0x83,0xf1,0x73,0x33,0xb4,0x05,0x88,0xa8,0x4b,
         0x34,0x54,0x67,0x1d,0x37,0x02,0x4f,0x96,0x49,0x07,0x39,0x2e,0x5c,0xdd,0x88,0xc8,
         0x52,0xda,0x92,0xcb,0x7e,0x9b,0x66,0x92,0xca,0x13,0xe1,0x40,0x63,0xbd,0x98,0x7d,
         0xe9,0xa8,0xc4,0x35,0xb5,0x31,0x1d,0x81,0x58,0xaf,0xb6,0x41,0xcd,0x52,0x01,0x34,
         0x0a,0xb6,0xb2,0x01,0xc6,0x3f,0x31,0xe9,0xc9,0x6e,0xa9,0x71,0xc8,0xa6,0x42,0x5f},
        /*TST_dQ*/
        {0x3a,0x05,0xff,0x84,0xcc,0x6a,0xb0,0xed,0xdc,0x46,0x35,0x73,0x01,0x2a,0xc6,0x47,
         0x44,0xe7,0x3b,0xa3,0x02,0x62,0xcd,0x64,0x5d,0x9b,0xe2,0x78,0xde,0x18,0xed,0xc7,
         0x4a,0xb0,0x40,0xfa,0xc2,0x31,0x3c,0x6c,0xd9,0xc7,0x8c,0x6c,0x2c,0x14,0x5f,0x6b,
         0xd5,0x8f,0x9b,0xf5,0x4c,0xe1,0xbc,0x1e,0x4b,0x04,0x45,0x25,0x34,0xd7,0xeb,0xbb,
         0x98,0x83,0x59,0x7e,0x5f,0x6a,0x5f,0x8d,0x97,0xcf,0x2a,0xb4,0xee,0x0c,0x9c,0xe5,
         0x6c,0x4c,0x82,0xc4,0x6e,0xf4,0xa7,0x91,0x82,0xbd,0x72,0xb6,0x33,0xd6,0xe3,0xfe,
         0x6a,0x68,0xec,0x22,0xee,0xf4,0x27,0x05,0x27,0xbc,0x1e,0x36,0x18,0x2a,0x45,0x4c,
         0x81,0x4e,0xbd,0x0d,0x9b,0x74,0x22,0x00,0x8e,0x0a,0x65,0xb6,0x40,0x80,0x37,0xd1},
        /*TST_Qinv*/
        {0x33,0x78,0x62,0x66,0x02,0x52,0xda,0xf3,0xca,0xa1,0xef,0xc0,0xc4,0xae,0x13,0x10,
         0x9b,0xc7,0xe8,0x50,0x12,0x0c,0x77,0xe0,0x96,0x8d,0x23,0xd4,0xd7,0x13,0xa3,0xae,
         0xc7,0xcd,0x90,0xd2,0x4f,0x81,0x06,0x47,0x64,0xc8,0x4b,0x7a,0x1d,0x1c,0xeb,0x96,
         0x22,0xc3,0xbf,0x87,0x1e,0x1c,0x75,0x6a,0xe9,0xda,0x62,0xeb,0x05,0x27,0x9c,0xe3,
         0x40,0xe5,0x48,0xfe,0x51,0x93,0x73,0x44,0xf3,0x55,0x30,0xed,0xd9,0x3a,0x9c,0x4b,
         0xab,0x89,0x44,0x6b,0x38,0xf6,0xb5,0x35,0xbd,0xa7,0xf4,0x3d,0x10,0x2b,0xa5,0xdd,
         0x0a,0x92,0x32,0x1d,0xcc,0x96,0x06,0x46,0xfe,0x68,0x06,0x65,0x41,0xc1,0x2c,0x86,
         0x9f,0x8f,0x01,0xae,0x3a,0x9f,0xed,0x8d,0x58,0x37,0x61,0x36,0xd6,0xc0,0xc3,0xe0},
        /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),     
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x0c,0x5b,0xc0,0x19,0x59,0xe7,0xcf,0x70,0x62,0xf8,0x19,0xa6,0xc9,0xcc,0xa4,0x6a,
         0xcd,0x12,0x0b,0x30,0xda,0xfc,0x68,0x51,0x18,0xc4,0x87,0x06,0x57,0x8f,0xaf,0x97,
         0x6f,0x96,0x20,0xa9,0x83,0x1c,0xb2,0x69,0xc4,0xaf,0xe6,0xf3,0x9f,0x23,0xf9,0x92,
         0x41,0x7c,0x83,0xd2,0x73,0xfb,0xe9,0xa7,0x5d,0x55,0xe7,0xb4,0xd7,0x13,0xb0,0x17,
         0xce,0x40,0xbb,0x14,0xe0,0x93,0x1f,0xb2,0x2c,0xf1,0x1f,0x01,0x86,0x2f,0x3d,0x22,
         0xa4,0x47,0xbb,0x9d,0x02,0x39,0xae,0x9d,0x1a,0x1f,0xed,0x4a,0xf3,0xc4,0x17,0xa8,
         0x05,0x8b,0x3d,0x04,0x62,0x99,0x91,0x91,0x3f,0xac,0x1f,0x15,0xb3,0x9f,0x06,0x1b,
         0x05,0xe9,0xa6,0x4f,0xec,0xc8,0x35,0x9d,0xc3,0x8f,0x82,0x26,0xc8,0x6e,0x94,0x8c,
         0x8a,0x29,0x42,0x10,0x91,0x72,0xf7,0x6c,0xe3,0xb0,0x07,0x0b,0x2f,0xff,0x33,0x84,
         0xc3,0x5a,0xc2,0x13,0x15,0xd3,0xe2,0xdb,0x98,0x2f,0x44,0xba,0x34,0xcb,0xbe,0x63,
         0x6b,0x73,0x36,0xe5,0x27,0x11,0x70,0x6d,0x7a,0xb2,0x74,0x34,0xb6,0x8f,0xe9,0x09,
         0x57,0x67,0xc8,0x50,0x1c,0x7e,0x7b,0xe6,0xd4,0xb8,0xaf,0x7c,0xbe,0x2d,0x16,0x0f,
         0x76,0x44,0x3a,0xfe,0x8d,0x6d,0xc8,0xec,0xa9,0xd5,0x48,0x1f,0xbb,0x85,0x50,0x3f,
         0xef,0xbd,0x8b,0xfd,0x9f,0xf1,0xb8,0x00,0x09,0x67,0x49,0x74,0xc5,0xe9,0xf2,0xd5,
         0x26,0xf1,0x93,0x59,0x73,0xf7,0x84,0x98,0xa5,0xa3,0x25,0xbe,0x73,0xc8,0x1c,0xb4,
         0x1c,0xef,0xbb,0x20,0x59,0x4f,0x3a,0x74,0x92,0xda,0x15,0x76,0xa4,0x12,0xb0,0x21},
        /*TST_output_data*/
        {0},
        /*TST_Expected_output_data*/
        {0x9f,0x5c,0x50,0x40,0x5e,0xe3,0xcd,0x73,0xa8,0xfd,0x6e,0xc8,0x1b,0x10,0x48,0xc2,
         0x31,0xc7,0xb5,0x3c,0xff,0x91,0x2f,0x1b,0xa3,0x33,0x7c,0x3c,0x18,0x06,0x17,0x47,
         0x86,0xb0,0x88,0x3c,0x6a,0x65,0xb7,0xd2,0x9f,0x0d,0x89,0xbe,0x01,0xa2,0x2a,0x29,
         0x00,0x91,0xe2,0xa4,0x48,0xd2,0x0f,0x9e,0xb4,0xb8,0xc5,0xcf,0x7f,0xb7,0xbd,0x32,
         0xc9,0x9c,0x0b,0x34,0x9b,0x15,0x65,0x6d,0x93,0xf9,0x31,0x4e,0x71,0x23,0x3f,0xb8,
         0xae,0xc4,0x6a,0xa9,0x2a,0x37,0xbb,0x60,0xaa,0x58,0x64,0xa1,0xbd,0xfd,0xa8,0x01,
         0xb9,0x7c,0xd2,0x06,0x28,0xb5,0x85,0x31,0xff,0x08,0xd6,0xa4,0x52,0xa3,0x92,0xc4,
         0xa6,0x3f,0xf4,0x9e,0xcf,0x18,0x54,0x8c,0x0a,0xa6,0x80,0xf6,0xc6,0x67,0x72,0xb9,
         0x85,0x0b,0x82,0x83,0xc0,0x8b,0x1c,0xd3,0x62,0x55,0x7d,0xca,0x83,0x82,0x44,0x3d,
         0xbb,0x47,0xbb,0x8d,0x5c,0x03,0x53,0xea,0xa1,0xe5,0x5a,0x96,0x9e,0xa9,0x8e,0xb2,
         0x4f,0x3b,0x8e,0xcf,0x2e,0x31,0xb6,0x01,0xc7,0xff,0x4f,0x3f,0xc8,0xba,0xda,0x6b,
         0xa1,0x0a,0xd7,0x66,0x9b,0x7b,0xd4,0x9c,0xce,0xb5,0xf5,0xeb,0x56,0x17,0x8d,0x30,
         0x2f,0x14,0xbf,0xe0,0x99,0x23,0x7c,0x7f,0x42,0xe4,0x85,0x27,0x97,0x8b,0x16,0xc4,
         0xa4,0x88,0x53,0x6c,0x33,0x1c,0x24,0x22,0xaf,0xf5,0xd1,0xe1,0xac,0x3b,0xab,0xe2,
         0x23,0x7a,0xff,0xe0,0x68,0x47,0x8b,0x86,0x7e,0x71,0x2a,0x1c,0xbe,0x45,0x05,0x3d,
         0x28,0x84,0x0c,0x50,0xab,0x05,0x72,0x27,0xc3,0xc6,0x0b,0xa7,0x3c,0xf9,0x1a,0x26}
    }
};

SEP_RSA_TestSignVerifyDataStruct SEP_RSA_Acceptance_SignVerify_TestData[] =
{
   { 
        {"Acceptance test - RSA SignVerify 1536byteData/2048bit key "},
        /*TST_PrivetExponent_D*/
        {0xad,0x39,0x0a,0xd1,0x7e,0xf9,0x71,0x86,0xbb,0xcf,0x0f,0x55,0x34,0xc2,0x7d,0x4d,
        0xce,0x15,0x00,0xd9,0xe9,0x17,0x6d,0xd6,0xbd,0xd7,0x86,0xda,0xd2,0xc3,0x69,0xd2,
        0x73,0xff,0x19,0x2b,0x54,0xd9,0xab,0xf5,0xad,0x58,0x74,0xbf,0xe9,0xc2,0x82,0x36,
        0x4a,0x39,0xf8,0xaf,0x43,0xa6,0xec,0x48,0x90,0x35,0xd6,0x51,0xff,0xcf,0xa2,0x43,
        0x1c,0x5f,0x2e,0x67,0x21,0x6c,0x13,0xa9,0x79,0x64,0x17,0x38,0xd5,0x55,0x90,0xf9,
        0x62,0x88,0x3f,0x57,0x33,0xbe,0xe7,0xf7,0x3f,0x0c,0xb4,0x85,0x7e,0xf5,0xe3,0x71,
        0x4f,0x4f,0x8e,0x84,0x35,0xe3,0x5d,0xb5,0xbf,0x12,0x5e,0x75,0xff,0xde,0x8e,0x7c,
        0x3f,0xf6,0x52,0xad,0x92,0x19,0xb1,0x4a,0x66,0x68,0xbf,0xff,0x7d,0xd0,0x47,0xbb,
        0x7a,0xe8,0x24,0xd3,0xd3,0x55,0xe9,0x56,0xdf,0x30,0x74,0xf1,0xff,0x02,0xf6,0x96,
        0x8f,0x5f,0xb2,0x6f,0x39,0x3c,0x05,0x33,0xf0,0x21,0x1a,0x95,0x90,0x2e,0xf8,0xdb,
        0xcf,0x0b,0xb4,0x91,0xe4,0xd6,0x73,0xc7,0x87,0x32,0x02,0x1e,0xc2,0x58,0x6f,0xe8,
        0x4e,0x84,0x91,0x51,0xcd,0xcf,0xb4,0xd7,0x15,0x23,0x93,0x7a,0x92,0x5b,0xdc,0xdf,
        0xc3,0xea,0xb3,0xd4,0xd8,0xb5,0xdb,0xe5,0x29,0x5d,0x4c,0x5f,0xdb,0x8d,0x32,0x82,
        0x20,0x50,0x17,0xe1,0x81,0x8e,0xdd,0x93,0x07,0x7a,0xdd,0xf6,0x9a,0x57,0x5b,0x89,
        0xc9,0x40,0xe4,0x86,0x63,0x80,0xac,0xa1,0x0f,0x17,0x98,0x6a,0x36,0x91,0x37,0x0d,
        0xd4,0x9b,0x84,0x07,0x87,0x67,0x28,0x66,0x2f,0x1a,0xa0,0x41,0x91,0x84,0xe1,0xd1},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xd3,0xa8,0x85,0xb1,0x1f,0x30,0xd1,0xdb,0x37,0x7d,0x29,0x29,0xb2,0x55,0x6d,0x08,
        0xaa,0x28,0x81,0xe4,0xf9,0xb9,0xa9,0x46,0xe7,0xa6,0x5e,0x35,0x9d,0xf9,0x9b,0x6a,
        0x3c,0x11,0xdb,0x33,0xf0,0x5e,0x64,0x9c,0x23,0x45,0xc0,0x76,0xf8,0xda,0x29,0x03,
        0x3f,0x67,0x96,0x0c,0x16,0x2d,0x04,0x8f,0x79,0xe4,0x80,0x41,0xc7,0xea,0xa0,0x92,
        0xec,0x40,0x46,0x97,0xc7,0x1f,0x46,0xfd,0x7c,0x24,0x33,0x61,0x4b,0x31,0xc3,0x8d,
        0x02,0x34,0x0d,0x83,0xa6,0xd5,0x3b,0xba,0x9d,0xc1,0x0d,0x82,0x20,0x51,0xb9,0x47,
        0xda,0xe3,0xd4,0x56,0x16,0x11,0x63,0xfd,0x01,0x9f,0x93,0x4b,0x3b,0x74,0x3d,0xc1,
        0x7c,0x8c,0x11,0xa8,0xc6,0x21,0x32,0x8e,0x1d,0xe9,0x9d,0xf2,0x48,0x20,0x8f,0x05,
        0x84,0x1c,0x45,0x93,0x16,0xae,0x81,0xfb,0x5b,0xf9,0xbd,0x36,0x2a,0x78,0x6e,0x88,
        0x56,0x05,0xd6,0xe8,0x36,0x34,0x3b,0x0e,0xbf,0x19,0x65,0x35,0x4a,0x83,0xdf,0x9b,
        0xb4,0xa3,0x3f,0x9e,0xf1,0x9d,0x35,0x96,0x58,0xee,0x91,0x2a,0x04,0x44,0xc4,0xd6,
        0x36,0x35,0x95,0x14,0xf6,0xd1,0x8b,0xa5,0xf4,0x8f,0x21,0x50,0x09,0x25,0xf2,0x6f,
        0x89,0xd7,0x11,0xf7,0x25,0xd4,0x5a,0x06,0xa2,0xf2,0x2e,0xaa,0x51,0x95,0x3a,0x50,
        0xbd,0xa0,0x1e,0xb4,0xa3,0x4e,0x23,0x05,0xb9,0xe0,0x70,0x46,0xaa,0x4b,0x09,0xee,
        0xca,0xa6,0xbf,0xb8,0x2c,0x82,0x06,0x40,0x6d,0xb4,0x46,0x3f,0x8a,0x68,0x08,0xa8,
        0x86,0x56,0xfa,0xe5,0x5e,0x18,0x9f,0x3f,0x18,0x4e,0xf3,0x0b,0xae,0xdf,0x05,0x71},
        /*TST_P*/
        {0xec,0x58,0x16,0x55,0xca,0x1f,0xfa,0x53,0x64,0x91,0x2a,0x51,0xfd,0x57,0x08,0xb6,
        0x9e,0x5b,0x82,0x91,0xb0,0x42,0xad,0x62,0x0a,0x37,0x83,0x4a,0xdc,0x1c,0xab,0xef,
        0xbb,0x59,0x04,0x62,0x0f,0xf6,0xb0,0x03,0x4a,0x0d,0x97,0x70,0x61,0xc2,0xbf,0x3c,
        0x2e,0xb9,0x4f,0xe3,0xa1,0xf4,0x6f,0x6b,0x79,0x98,0xc4,0x5a,0xc4,0xd0,0x82,0x0a,
        0x00,0xda,0x54,0xb9,0x9e,0x0a,0x68,0xe2,0x12,0x7a,0x29,0xf7,0xbc,0xe9,0x44,0x44,
        0x8a,0xaf,0xba,0x34,0x4a,0xa0,0x3f,0x44,0x42,0xb1,0xfb,0x78,0x86,0xd6,0xe6,0x2b,
        0xc7,0xa7,0xa0,0x6f,0xde,0x75,0x62,0xdb,0x61,0x17,0x93,0xc3,0xb3,0x3c,0xbf,0x97,
        0x42,0x97,0x7e,0x1f,0xb2,0x15,0x9c,0x16,0xff,0x97,0x4d,0x34,0x8c,0xa5,0xdc,0x83},
        /*TST_Q*/
        {0xe5,0x42,0xdb,0xe2,0xab,0x91,0x50,0x66,0xb0,0x86,0x3d,0xd8,0x6a,0x81,0x6b,0xce,
        0x85,0x0f,0xca,0xff,0x6d,0xbd,0x2c,0x62,0x3e,0x25,0x79,0x1b,0xe2,0x70,0x8d,0x41,
        0x71,0x5c,0x15,0x7c,0x69,0x68,0xda,0x50,0x16,0xe8,0xb8,0x6d,0x92,0x48,0xa8,0xe8,
        0x7b,0xff,0x64,0x7d,0xdf,0xc4,0x73,0x45,0xe8,0x22,0x84,0xe8,0x1a,0xa0,0x3e,0x6a,
        0x9c,0x16,0x13,0x36,0x54,0x8d,0x92,0x3e,0x2d,0xe7,0xec,0xe2,0x80,0x4b,0xbf,0x99,
        0xfa,0xaf,0x36,0x76,0xb7,0xa3,0xae,0x05,0xd3,0xe6,0x8c,0xda,0x8b,0xee,0xd5,0x31,
        0xb3,0x8b,0x1c,0xe1,0x5c,0xcf,0xca,0xe3,0x17,0xfc,0xd3,0x77,0x2a,0xfb,0xf3,0x10,
        0x68,0x39,0xc9,0x16,0x08,0x0a,0x31,0x15,0xb1,0xcf,0x3a,0xa3,0xc9,0xaa,0x1b,0xfb},
        /*TST_dP*/
        {0x7d,0xf2,0xef,0x6c,0x26,0x7b,0xe6,0x1d,0xfc,0xd0,0xf3,0x79,0xa0,0x05,0x7a,0xaa,
        0x3f,0x37,0xcb,0x1c,0x32,0x8f,0x45,0xf0,0xa2,0x3b,0x35,0x27,0x76,0xa7,0x7c,0xe5,
        0x13,0xb4,0xfb,0x85,0xfa,0xb5,0xde,0xd4,0xd1,0xe8,0xee,0x54,0x40,0x74,0xd5,0x0e,
        0x90,0x63,0xc6,0xf4,0x2b,0x01,0xa5,0x42,0xe4,0x19,0x0a,0x42,0xc8,0xf1,0xc8,0xea,
        0xe5,0xcb,0x74,0x2d,0x3a,0xd0,0x97,0x56,0x2a,0xbc,0x99,0x92,0xe1,0x44,0x7a,0x52,
        0x00,0x8a,0x67,0x33,0xa8,0xb5,0x3f,0x21,0xf4,0x5c,0xff,0x03,0x1a,0xf0,0x78,0xd6,
        0xc9,0xde,0x45,0xbc,0x78,0x13,0x9c,0x6c,0x06,0x90,0xd6,0xf9,0x0a,0x92,0x8c,0x13,
        0x62,0xb4,0x72,0xcd,0x17,0x4d,0x36,0xd2,0x76,0xc0,0xbd,0xaf,0x0c,0x68,0xf3,0x5b},
        /*TST_dQ*/
        {0xae,0xf4,0x87,0xd3,0x02,0x35,0x01,0xd3,0x6b,0xf0,0xf5,0xef,0x5a,0xcf,0xeb,0x52,
        0x8e,0x0e,0xd0,0x4e,0x7f,0x13,0x77,0x74,0x7d,0x92,0xa1,0x4a,0x9b,0x52,0x63,0x29,
        0xc6,0xf5,0x8b,0xdc,0x06,0xa1,0x22,0xc1,0x2d,0xca,0x69,0x3c,0x0c,0xff,0x70,0x0f,
        0x02,0xd9,0x92,0x79,0xd0,0xb3,0x1d,0x79,0x02,0xbe,0x9d,0x08,0x77,0x91,0x44,0x30,
        0x9d,0x6e,0xe7,0x38,0x75,0xec,0x17,0xe7,0x65,0xa6,0xf1,0x0a,0xa4,0xf7,0xa9,0x7f,
        0x3b,0x64,0x4c,0xbe,0xea,0x43,0x79,0xc1,0x2e,0xc5,0x69,0x46,0x3a,0xb5,0x87,0x72,
        0xc7,0x5e,0x69,0x2a,0xbe,0x66,0x40,0xa1,0x6f,0x23,0xdc,0xc8,0xbb,0x3f,0xcc,0x6c,
        0xff,0xec,0xe1,0x3c,0xf3,0xe3,0xbb,0x33,0xa0,0x1e,0xd1,0xd4,0x3e,0x48,0x97,0xd3},
        /*TST_Qinv*/
        {0x8f,0xb7,0x06,0x99,0x7b,0x1e,0x75,0xe4,0x5d,0x5a,0x18,0xfa,0x0f,0xcd,0xa6,0xf6,
        0x6c,0x08,0x38,0xf4,0xd4,0x81,0x3a,0x11,0xf0,0x66,0x22,0x85,0xf9,0xda,0x5a,0x2b,
        0x93,0x51,0x58,0x37,0x70,0xcd,0xd6,0xdc,0xa1,0xbd,0x04,0x87,0x80,0xde,0xe4,0xf0,
        0x3b,0xe5,0x79,0x88,0x14,0x3d,0x45,0x74,0x09,0xbc,0xcc,0x1b,0xc1,0x72,0xea,0x07,
        0xa7,0x7f,0xb2,0x24,0x6a,0x08,0x38,0xde,0x64,0x18,0x45,0x6b,0xa9,0x40,0xda,0x2e,
        0xd0,0xee,0xa4,0x28,0x87,0xcd,0x6e,0x83,0x4b,0x76,0x0f,0x2c,0x27,0xd5,0xf6,0xa9,
        0xb2,0x33,0xd6,0x45,0x7e,0x95,0xd1,0xab,0x84,0xcc,0x59,0x9e,0x01,0x41,0x17,0x80,
        0xad,0x18,0xe8,0x83,0x25,0xe4,0x09,0x32,0xdc,0xab,0xa8,0xba,0x97,0xb6,0xf4,0x56},
        /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),    
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0x5e,0x1f,0x8b,0x2c,0xc9,0xe4,0x74,0x10,0x84,0xbe,0xff,0x5e,0x0e,0x04,0xbe,0xaf,
        0xab,0xbc,0x2b,0xeb,0xb5,0xa6,0x96,0x6a,0x33,0x7d,0x62,0x59,0xad,0x79,0x71,0x60,
        0x3e,0x18,0xdd,0x81,0xea,0x1e,0xe9,0x44,0x32,0xda,0x37,0x11,0xe6,0xac,0x3b,0xdd,
        0x3b,0xc4,0xef,0x09,0x1d,0x2c,0xc8,0x86,0xc6,0x09,0xe9,0x3e,0x90,0x1e,0x98,0xaf,
        0x07,0x91,0xee,0xd9,0x43,0xf2,0xd2,0x5b,0x75,0x79,0x28,0xd9,0xbf,0x8f,0x45,0xa0,
        0x49,0x90,0xa6,0x8d,0x91,0xd0,0xe2,0x2b,0x02,0xdc,0xde,0x1b,0xc9,0x02,0x40,0xb9,
        0xe4,0x13,0x26,0xfc,0x7b,0x67,0x17,0x9e,0x74,0x22,0x3a,0x7d,0x42,0xb6,0xc5,0x42,
        0xfd,0xa9,0xb9,0x40,0xb8,0x99,0xcd,0x9f,0x0f,0x7d,0xa7,0xb9,0xff,0x2d,0x52,0xc4,
        0xfb,0x25,0xed,0xb2,0x3b,0x85,0xa0,0x55,0x58,0x5d,0xd5,0xc7,0x16,0x28,0xa4,0x09,
        0x80,0x96,0x8e,0xea,0x3b,0x8f,0x6f,0x2a,0x14,0x74,0xae,0xe0,0xdb,0xa8,0xb7,0x19,
        0x74,0x4f,0xab,0xc2,0x2b,0x55,0x55,0xc8,0x48,0xb2,0x61,0x7d,0xe3,0xed,0xc8,0x3e,
        0xfa,0xdf,0x8f,0x53,0xc1,0xba,0xb1,0x16,0x39,0x4a,0x5a,0x57,0x04,0x7a,0x55,0x00,
        0x78,0x19,0xc8,0xf5,0xf2,0xde,0x1f,0x3e,0x6d,0xaa,0x46,0x68,0x53,0x0e,0x1b,0x28,
        0x92,0x0d,0x23,0x42,0xf3,0x23,0x7b,0xa9,0xa8,0x86,0x12,0xe8,0x23,0xab,0x16,0xc0,
        0x2f,0x0c,0xac,0x13,0x39,0x29,0xe4,0x01,0xee,0xcc,0xec,0x50,0x0c,0x92,0x84,0x11,
        0x71,0xa7,0xb1,0x80,0x79,0xd1,0xb6,0x2d,0x86,0xb0,0x40,0x59,0xe0,0x44,0xe1,0xa3,
        0xc0,0xaf,0xbf,0xe4,0xa7,0x3c,0x8e,0x57,0xf4,0xa1,0xbb,0xfd,0xb6,0x81,0xea,0x3f,
        0xbf,0x35,0xa3,0xd6,0xfa,0xcc,0x48,0xe8,0xfe,0x50,0x4b,0x73,0xe2,0x4b,0x9d,0xef,
        0x53,0x8a,0x6a,0x2f,0xe5,0x21,0x03,0x89,0xa7,0xb0,0x1c,0x36,0xfa,0xe4,0x37,0xfb,
        0xa3,0x40,0x60,0x09,0x1e,0x1d,0x1b,0x23,0x35,0xef,0x9b,0xfe,0xd2,0xcb,0x34,0xed,
        0x12,0x26,0x13,0xbe,0x9a,0xe0,0x2d,0xde,0x2e,0x81,0x75,0xc4,0x80,0xc2,0x52,0x8d,
        0x45,0x4f,0x50,0xe4,0x8e,0xcb,0x16,0x25,0x56,0x14,0x98,0xc2,0x57,0xc9,0x8d,0xe5,
        0x23,0x0a,0x24,0x57,0x6f,0x7f,0xf2,0xa0,0xb2,0x9c,0x2f,0x70,0xef,0x23,0x23,0x3d,
        0xce,0xea,0xdb,0x2e,0xf2,0xde,0x20,0x38,0x87,0x48,0xaa,0x87,0x1a,0x4f,0x90,0x1f,
        0xae,0xbe,0x03,0xc3,0x0c,0x08,0x3c,0x15,0x5a,0x8a,0xb3,0x00,0xef,0x0f,0x92,0x53,
        0x66,0x99,0x69,0xae,0xf1,0x5f,0x23,0xa2,0xf0,0x12,0x39,0x14,0xc3,0x64,0x25,0xe2,
        0xdc,0xcb,0x1a,0xca,0x18,0x82,0xf2,0x87,0x4f,0xd2,0x68,0x3c,0x2a,0x8f,0x87,0x16,
        0x34,0xe5,0x62,0x2d,0x34,0x55,0x06,0xac,0xbb,0xfa,0xad,0x32,0xf9,0x11,0x34,0x78,
        0xd4,0xb8,0xcf,0x33,0x3c,0xf6,0xfc,0x3c,0xb8,0xfc,0xb5,0xee,0x45,0xaa,0xea,0xcf,
        0x61,0x55,0x2e,0x73,0x63,0xc8,0xb1,0x9e,0x0d,0x88,0x6e,0xa9,0x64,0x5d,0xa5,0x27,
        0xbf,0x0d,0x8c,0xc8,0x1f,0x6b,0x42,0x7d,0xbe,0x90,0x04,0xdc,0xeb,0x69,0xa3,0xc7,
        0x14,0x72,0x35,0x48,0x25,0xc0,0x0b,0xc0,0x11,0x45,0xe4,0x41,0xad,0x50,0x60,0x38,
        0xc5,0x53,0xb8,0x4f,0x6a,0xe9,0xab,0x91,0x89,0x17,0xbc,0xcf,0xc2,0xd2,0x9a,0x43,
        0x76,0xc2,0xe0,0x74,0x22,0x46,0xfe,0x59,0xec,0xb8,0x77,0xc1,0x7c,0xf2,0x4e,0xf3,
        0x0d,0x11,0xba,0x91,0xc4,0x79,0x21,0xc2,0x40,0x19,0x44,0x8f,0x72,0xf0,0xb8,0x8e,
        0xaf,0xcf,0x95,0xbe,0x03,0x61,0x72,0xb3,0xc9,0x6a,0x90,0xf3,0x78,0x4c,0x55,0x9f,
        0xc0,0xcf,0xfc,0x56,0xd6,0x21,0x8c,0x56,0x0c,0x1c,0x06,0xe4,0xa4,0xc8,0xe3,0xef,
        0xe6,0x21,0xbd,0xf0,0x70,0x1a,0x4d,0x14,0xce,0xe1,0x95,0x9d,0x4a,0x65,0x5e,0x85,
        0x05,0x16,0xe5,0x65,0x47,0xeb,0xd2,0x96,0x14,0xaa,0x69,0x96,0x00,0x64,0x04,0xad,
        0x44,0x3e,0xc1,0xd0,0x10,0x78,0x78,0xc5,0x23,0xa7,0xf0,0x88,0x9a,0x45,0x52,0xee,
        0x05,0x6c,0xdd,0x88,0xc0,0xdf,0xdc,0xca,0x81,0x4a,0xd5,0x6c,0x2d,0xcb,0x04,0x11,
        0xf0,0xb0,0x07,0x27,0x8c,0x83,0xdb,0x0e,0xf1,0x44,0x07,0x7c,0x0f,0xf5,0x17,0x20,
        0xe8,0x5c,0x4c,0x85,0xe9,0x04,0x92,0x3a,0x7a,0x85,0xb2,0x30,0xd4,0x05,0xc9,0x63,
        0x12,0xff,0xf9,0xbc,0x8b,0x43,0x5e,0x36,0x60,0x3e,0x44,0x41,0x51,0x7c,0x97,0x64,
        0xd5,0x6b,0x9a,0x25,0x69,0x62,0xdc,0x2d,0x28,0xe1,0x69,0xa8,0x9c,0x1b,0x3d,0xeb,
        0xd4,0xb1,0xfe,0x59,0xb6,0xc1,0xea,0x87,0x97,0x1f,0x0e,0x9e,0x09,0xe2,0xb8,0x01,
        0xf4,0x23,0x30,0x30,0xe9,0x01,0xa3,0xed,0xb2,0xe8,0x60,0x9d,0x2e,0x14,0x47,0xf0,
        0x5c,0x50,0x7d,0xc4,0xb5,0x04,0x65,0x47,0xbf,0x6e,0xcc,0x5c,0xdf,0x30,0x64,0x41,
        0x6e,0x0b,0x74,0x6e,0x10,0xea,0xcd,0xc0,0x41,0x22,0x00,0xd6,0x31,0xf8,0xce,0xbc,
        0xd2,0x64,0xe0,0xc6,0x2f,0x14,0xb9,0xbf,0xff,0xb4,0xe8,0x43,0x7a,0x6d,0x82,0x6a,
        0x6b,0xab,0xcf,0xa7,0x87,0x24,0x44,0xef,0xfd,0x16,0xb1,0x1d,0x4e,0xcf,0xbc,0x95,
        0x5f,0x73,0x8e,0x27,0xcd,0xfa,0xcc,0x37,0x80,0x78,0xc9,0x1b,0x83,0xa1,0xfa,0xc5,
        0x12,0x8c,0xaa,0xa2,0xf5,0xb7,0xee,0xc1,0x0d,0x4c,0xdc,0x38,0x2d,0xa2,0xf8,0xc4,
        0x2b,0x07,0xef,0xaf,0x36,0xbd,0x88,0xf7,0x69,0x42,0xd7,0xac,0xa1,0xd4,0xb4,0x9a,
        0x8c,0x35,0x6b,0x28,0x03,0xac,0xb5,0x80,0x9a,0x4c,0xe7,0xf0,0x75,0x78,0x6a,0x90,
        0x5d,0xa7,0x6b,0x26,0x12,0x65,0xd3,0x46,0xe3,0x9b,0x7a,0xbe,0x7d,0x0f,0x97,0x31,
        0x01,0x2e,0x7c,0x01,0x59,0x0a,0x80,0x72,0xcb,0x9f,0x3c,0x0d,0xce,0x5a,0xfa,0x43,
        0x1d,0xdc,0x6a,0x53,0x0b,0xfb,0x97,0x6e,0x16,0x09,0x1a,0x18,0xbe,0x59,0x8d,0xd1,
        0x98,0x00,0x43,0xf5,0x9e,0xd9,0x36,0xe1,0xc9,0xcc,0x41,0x57,0xe2,0x4f,0x90,0x24,
        0x95,0x2c,0x54,0xff,0xc7,0x85,0xbb,0xb5,0x29,0x16,0x1f,0x83,0x0d,0xbb,0x7e,0xc3,
        0x79,0x32,0x2a,0xcc,0x7a,0x21,0xc1,0x13,0xbb,0x5b,0x60,0x96,0x56,0x5f,0x14,0x7a,
        0xea,0x22,0x91,0xf2,0xee,0x0e,0x27,0x64,0x45,0x4a,0xf1,0xc7,0x12,0x3c,0x50,0x50,
        0xcd,0x4c,0x97,0x4d,0x97,0xeb,0x08,0x51,0xca,0xd4,0x00,0x91,0xd5,0x92,0x6e,0x8e,
        0x47,0x43,0x89,0xf4,0x29,0x9b,0xc3,0xc2,0x91,0x2c,0xf8,0xac,0x74,0xe4,0xec,0xbe,
        0xbc,0xd7,0xf4,0x41,0x9a,0x3e,0xf3,0xe2,0x1e,0xc0,0x88,0x11,0x05,0xf1,0x86,0xa8,
        0xd2,0x19,0xa5,0xcd,0x20,0x36,0x77,0x19,0x36,0x44,0x9d,0xfa,0xdc,0xbb,0x3a,0x55,
        0x6d,0x5a,0xa8,0x70,0x2e,0x23,0x6a,0x10,0xde,0xa7,0x62,0xde,0x8e,0x83,0x44,0x0f,
        0xb3,0x2b,0x4b,0x44,0x7a,0xe6,0x2b,0xaf,0x5b,0x1a,0x46,0x78,0xf1,0xca,0x22,0x5f,
        0x09,0x5d,0x1b,0xa2,0xf9,0xa1,0x55,0x21,0x33,0x0f,0xf5,0xc0,0x19,0x51,0x91,0x0d,
        0x13,0x01,0xe4,0x23,0xdf,0xb4,0xc7,0xce,0x29,0x37,0x5d,0xef,0x5c,0x18,0x8d,0x22,
        0xb7,0x68,0xb5,0x9f,0xa3,0xc0,0x9c,0x5e,0x44,0x82,0xa9,0x7f,0x4e,0x61,0x53,0xe8,
        0x1a,0x24,0xd9,0x30,0xf9,0xa6,0x33,0xbc,0xc8,0x22,0x48,0x27,0xc4,0xad,0x61,0xe7,
        0xa0,0x04,0xde,0x2e,0xd5,0x88,0x28,0x0f,0x3a,0x87,0xe6,0xe2,0xd4,0xbd,0x74,0xe9,
        0xef,0x1b,0x90,0x34,0x6d,0xc7,0x57,0xc1,0x5f,0x63,0x71,0xe8,0xd2,0x92,0x88,0xf6,
        0xeb,0xb8,0xfe,0x19,0x37,0x02,0xdf,0x7c,0x3c,0xa7,0x14,0xb2,0x54,0x6d,0xda,0x58,
        0xbb,0x6e,0x73,0xf6,0xe6,0x1c,0x1b,0x27,0x16,0x83,0x3e,0xfa,0x2e,0xce,0xe8,0x97,
        0xc1,0x0d,0x7d,0x26,0x70,0x35,0xaa,0xec,0x73,0x68,0x9b,0xb7,0x75,0x77,0x6f,0x7d,
        0xa5,0xa6,0xe9,0x40,0x0a,0xaf,0x68,0x34,0x16,0x09,0x19,0x24,0x7f,0x69,0x6b,0x12,
        0x4a,0x8a,0xc3,0x1e,0x29,0x2a,0x72,0xa9,0x06,0x55,0xe4,0xb9,0xe0,0xe5,0x19,0x9f,
        0xd6,0x4a,0x59,0xd8,0x81,0x87,0x24,0x32,0x87,0x7d,0x69,0x2f,0x6d,0x6c,0xf8,0xae,
        0xad,0xb7,0x38,0xc8,0x09,0xe7,0x1d,0xf9,0x1e,0xf3,0x55,0x80,0x3c,0xbf,0xc2,0x08,
        0x75,0xe2,0x2d,0x87,0xf4,0xac,0x39,0x67,0x91,0x68,0x95,0xe4,0xa2,0xde,0x76,0xb5,
        0x13,0x1c,0x45,0xee,0xb9,0x76,0x94,0x25,0xe3,0xcc,0x57,0xd3,0x32,0x0b,0x51,0xfe,
        0xab,0xf6,0xcc,0x15,0x0b,0x27,0x8d,0x1c,0x5a,0x50,0x07,0x08,0xc3,0xc7,0xcf,0x6d,
        0xa3,0x42,0x50,0x56,0xe0,0xdf,0xc0,0x74,0x7c,0x67,0x53,0x7c,0x6a,0xd3,0xae,0xca,
        0xa0,0x0f,0x9e,0x4a,0x6d,0xff,0x0a,0x98,0x0d,0xc0,0x26,0x66,0x7b,0x30,0xea,0x1f,
        0x86,0xb0,0xc3,0xc9,0x27,0x28,0x88,0x30,0x12,0x4c,0xaf,0x41,0x8b,0x1e,0xc1,0xb4,
        0x7b,0xb4,0x0b,0xee,0xc3,0x3c,0x97,0x25,0xd0,0x3d,0x5a,0xc5,0x6f,0x20,0xaf,0x12,
        0xe3,0xee,0x04,0x0f,0x36,0x5b,0xd3,0x9f,0xcc,0x04,0xd5,0xeb,0x3e,0xf5,0x72,0x03,
        0x65,0x6e,0x7b,0xc8,0xb4,0xe7,0x1b,0x09,0xcb,0x51,0x0b,0xec,0x4a,0x9f,0x06,0x90,
        0xe3,0x85,0x7d,0xf0,0xb4,0x7f,0x8b,0x0b,0xd3,0x16,0x2b,0x42,0x2a,0x5f,0xa9,0x01,
        0x85,0xc4,0x56,0xa1,0xe9,0x06,0x80,0x8d,0x28,0x83,0xa1,0xa4,0xb2,0xb5,0xd7,0xdf,
        0xae,0xfc,0x94,0x34,0x49,0x9d,0x97,0xba,0x4e,0x0a,0x1b,0x0d,0xf8,0x64,0x4e,0xf4,
        0x04,0x3e,0x04,0x41,0x09,0xa4,0xad,0xf9,0x0c,0x5b,0x84,0xb5,0x4f,0x6b,0x0a,0x48,
        0x6b,0xdb,0xb3,0xa2,0x9e,0xbc,0xdf,0xf5,0x66,0x69,0x0b,0x16,0x4f,0x0c,0x49,0x25,
        0x09,0x64,0xed,0x70,0xbd,0xc6,0x8a,0x95,0xa1,0x62,0x1d,0xe7,0xcb,0xc8,0x87,0x13},
        /*TST_input_dataSize*/
        1536*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    }
    
};

SEP_RSA_TestExtHashSignVerifyDataStruct SEP_RSA_Acceptance_ExtHashSignVerify_TestData[] =
{
        /***************/
        /*  RSA External Hash SignVerify test data */
        /***************/
	{
        /************/
        /*  2048 bit key                  */
        /************/ 
        {"Acceptance test - RSA External Hash SignVerify 2048bit key "},
        /*TST_PrivetExponent_D*/
        {0x26,0xf9,0x21,0xa5,0xa0,0x34,0x53,0x86,0x17,0x00,0x93,0xb5,0xef,0x9b,0xa0,0xf9,
         0xe9,0x17,0xd7,0xb2,0x6b,0x26,0xa7,0x29,0xd7,0xfd,0x7a,0x13,0xf1,0x9b,0x2b,0xe1,
         0x95,0x63,0x2c,0xf2,0x30,0xed,0xe3,0xf4,0xcb,0x88,0xba,0x9c,0x8f,0x45,0x5c,0x60,
         0x79,0xbe,0x97,0x27,0x8e,0x23,0x82,0x34,0x7f,0x56,0x86,0x71,0xcb,0x09,0x03,0x31,
         0x5d,0x46,0xc6,0xaa,0xd8,0x96,0xf9,0xe5,0x59,0xdc,0x44,0x5d,0x50,0xbd,0xfc,0x8e,
         0x1f,0xfa,0x5a,0x99,0xb7,0x44,0x07,0xd5,0x87,0x90,0x5a,0x96,0x16,0x17,0x3d,0x89,
         0x49,0xd3,0xd4,0x03,0x09,0x5b,0x00,0xef,0x8a,0x66,0x78,0x5b,0x21,0x32,0x06,0x1e,
         0xa7,0xe3,0xc8,0xcb,0x6f,0xf6,0x50,0xb6,0x22,0x12,0x65,0x0a,0x69,0xbc,0x78,0x04,
         0xb1,0xa2,0x64,0xd0,0xa1,0x04,0x96,0xc3,0x3e,0xfa,0xc3,0xcf,0xed,0x49,0xbe,0x21,
         0xcf,0xbc,0x31,0x3f,0x28,0x09,0x2e,0xad,0xd6,0x92,0xe1,0xfb,0xb6,0xbd,0x67,0x31,
         0x75,0x59,0x01,0x43,0x55,0x74,0x5b,0x6e,0x28,0xab,0x0b,0x08,0x47,0x97,0xc0,0xe3,
         0xa2,0x44,0x45,0x65,0x3d,0xab,0x40,0x46,0x9b,0x47,0xfe,0x46,0x22,0xa1,0x84,0x04,
         0xc6,0x79,0x84,0xc7,0xf3,0x25,0x60,0xae,0x95,0xaa,0x98,0x84,0xc6,0xc5,0xa7,0xde,
         0x7c,0x57,0x79,0x34,0x06,0x7e,0xd4,0x80,0x50,0x3d,0x98,0xd5,0x0c,0x06,0x73,0xd9,
         0xa0,0x25,0x60,0xbf,0x13,0x4e,0x59,0x9a,0x05,0xf8,0x24,0x7f,0xaf,0x29,0x9b,0xc4,
         0x8b,0x93,0x4c,0x44,0x2e,0xf1,0x21,0x3d,0x87,0xce,0xd6,0x3b,0x52,0xa0,0x92,0x11},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xdc,0xdf,0xb1,0x56,0xe8,0xc1,0x1f,0x7d,0x2d,0x92,0xf7,0x33,0x58,0x24,0x7e,0xed,
         0x5c,0x93,0x02,0xf8,0xe3,0xf4,0x02,0x22,0xde,0xc7,0x48,0xe8,0x9d,0x99,0xc1,0xc3,
         0xfd,0xa0,0x3d,0x65,0x57,0xee,0xc0,0x91,0x90,0xe7,0x13,0x82,0x7a,0x10,0xba,0x70,
         0x98,0x49,0x57,0x01,0x17,0x5b,0x4d,0xa8,0xb9,0x23,0x48,0x5a,0x5a,0xbc,0xed,0x8b,
         0xa7,0xa1,0x29,0x36,0x43,0xde,0xc2,0x8d,0x96,0x4e,0x6a,0xa6,0x69,0x45,0x73,0xd3,
         0xa5,0xdd,0xb3,0x0d,0x0e,0xea,0x49,0x00,0x13,0x41,0xd7,0x3b,0x6e,0xb7,0xbc,0x01,
         0x39,0xc2,0x7f,0x7c,0xe3,0x00,0x23,0xa7,0x58,0x98,0x5e,0x40,0xda,0x7a,0xe4,0xa7,
         0x23,0xbd,0x6c,0xcf,0xc1,0xb2,0xf9,0xcf,0xb6,0x83,0xbe,0x66,0xde,0x6a,0x1f,0x61,
         0x44,0x00,0xc9,0xd1,0x1d,0xd9,0x6f,0x9f,0xf0,0x17,0x6b,0xcb,0x02,0xc8,0x3b,0xa5,
         0xf8,0x88,0x08,0xea,0xb3,0x8d,0xeb,0x8c,0x44,0x89,0x54,0xb1,0xce,0x35,0x71,0x35,
         0x2c,0xbc,0x47,0x2d,0xb7,0x2b,0x6c,0xed,0x4f,0x72,0x3b,0x4e,0x5c,0x9a,0xe5,0x3e,
         0xd8,0x46,0xf2,0x51,0xad,0x9b,0x31,0x94,0x1c,0xd8,0xd7,0x7b,0x5e,0x69,0xa6,0x25,
         0x87,0xbb,0xc2,0xb8,0x38,0x8a,0x57,0x5e,0xcc,0x89,0xa0,0xfb,0x86,0x44,0x86,0x24,
         0x01,0x82,0xf8,0xce,0xb9,0xa7,0x38,0xf0,0xde,0xb4,0xcd,0x32,0x74,0x43,0x94,0x81,
         0x95,0x15,0x77,0x3d,0x73,0xf7,0x34,0xa0,0xc6,0x0e,0xb0,0x72,0x91,0x50,0x2f,0x96,
         0xfc,0x3b,0x94,0xea,0xf4,0x89,0x6e,0x15,0xc7,0xb1,0x9f,0xea,0x93,0xac,0x57,0xe5},
        /*TST_P*/
        {0xf9,0xc5,0xea,0x97,0x33,0xa5,0x92,0x75,0xe9,0x2e,0x56,0x86,0x66,0xba,0x40,0x58,
         0x2d,0x9f,0xd0,0x28,0x3c,0x1c,0x7a,0x47,0xae,0x98,0xf8,0x34,0x7e,0xc2,0x69,0x46,
         0x91,0xea,0xba,0x22,0xbf,0xf7,0x88,0xcd,0x2f,0x24,0xb8,0x58,0xab,0xb4,0x1f,0x3d,
         0x18,0xaa,0x4d,0x90,0x7c,0xcc,0xf1,0x8d,0xb5,0xac,0x98,0xda,0x7e,0x93,0xcb,0xbd,
         0x29,0x59,0x7f,0x86,0xce,0x8e,0x66,0xb9,0x54,0x99,0xd2,0x22,0xc9,0x85,0x36,0x44,
         0x1e,0xfc,0x9e,0x8d,0x6a,0xd8,0xca,0xdd,0x14,0xd1,0xb7,0xdb,0x2a,0xd4,0xf6,0xd5,
         0xc3,0xc7,0x82,0x67,0x98,0x32,0x81,0x0d,0x4c,0xa9,0x4e,0xc3,0xd2,0x66,0x25,0xe1,
         0x1c,0xbf,0xf9,0x24,0xc8,0x3f,0xb7,0x6c,0xab,0x35,0xe7,0x38,0x58,0x73,0x25,0x0f},
        /*TST_Q*/
        {0xe2,0x61,0x56,0x59,0x38,0xa1,0xab,0xef,0x03,0x80,0x44,0x0d,0x3d,0xb6,0x10,0x4c,
         0xdd,0xa2,0xb0,0x0d,0x43,0x74,0xd5,0xf8,0xc2,0x32,0xc3,0x0f,0xef,0x2b,0x87,0x1d,
         0xb3,0xa5,0x92,0x6f,0xda,0x6e,0x39,0xf6,0xc5,0x55,0xaa,0x33,0xe2,0x4f,0xdf,0x58,
         0x8b,0xfd,0x2b,0xd9,0x79,0x68,0x05,0x02,0x56,0xe9,0x16,0xbb,0xc6,0x13,0x28,0xfd,
         0x6e,0xcd,0xb0,0xdf,0xf2,0xf1,0x51,0x58,0x33,0x48,0xaa,0x1c,0xab,0xde,0x6c,0x62,
         0x7e,0x10,0xa2,0x6f,0x5c,0x61,0x44,0xeb,0x91,0xf8,0x22,0x79,0xfa,0xcf,0x67,0x90,
         0xa1,0xf3,0xb4,0x18,0x45,0x33,0x5e,0xa5,0xd0,0x4e,0x09,0xc1,0x6f,0xfc,0xa8,0x41,
         0xcc,0x2e,0xa9,0x55,0x77,0x2c,0x38,0xdc,0x17,0xde,0xda,0x62,0xde,0xf4,0xbb,0xcb},
        /*TST_dP*/
        {0x54,0x9e,0x9b,0xc2,0x8c,0x09,0xcd,0x1b,0xcb,0x5b,0x1a,0x8f,0x40,0x20,0x5b,0x8a,
         0x44,0x32,0xbf,0x77,0xd2,0x1d,0xa7,0xc3,0xbf,0x40,0x2d,0xde,0xc3,0x0f,0x24,0x51,
         0x77,0x3f,0xf9,0xbd,0xaa,0x21,0xb7,0xa4,0x24,0x13,0xa1,0xac,0xd0,0xc7,0x1e,0x4a,
         0x39,0xa0,0x00,0xd5,0x31,0xa2,0xd1,0x37,0x3c,0x54,0x74,0x18,0x9a,0x07,0x82,0x5f,
         0xdc,0xb1,0x68,0x86,0x08,0x56,0xb0,0x30,0x9b,0x9b,0xdd,0x58,0x51,0xc3,0xa2,0xc5,
         0xe3,0x65,0x9c,0x65,0xb6,0xcc,0x29,0xb6,0x4a,0xc6,0x5e,0x2e,0x8f,0x4d,0x45,0x2e,
         0xd8,0xbc,0x2f,0xce,0xde,0xfe,0x45,0x40,0x77,0x37,0x68,0xea,0xe8,0xce,0x18,0x89,
         0x32,0x8f,0x4b,0x5e,0x0d,0xc5,0xa0,0x63,0xdd,0x81,0x4e,0x8b,0x85,0x53,0xc5,0x3b},
        /*TST_dQ*/
        {0x11,0xa0,0x80,0xa7,0xbb,0xd8,0x22,0xda,0x1e,0x8c,0xab,0x3f,0xd8,0xb1,0x47,0x7d,
         0xa4,0xb8,0x59,0x3a,0xff,0x28,0xa6,0xcc,0x92,0xda,0x7f,0x03,0xcb,0x9c,0xb9,0x0d,
         0xa0,0x02,0x61,0x6f,0xa2,0x33,0x79,0x01,0xf5,0x05,0xa1,0x96,0x1e,0xa6,0x17,0x7e,
         0xfe,0x8f,0x7d,0x0d,0x96,0xfd,0x79,0x7e,0x60,0x24,0x10,0x28,0x18,0xd9,0x3f,0x14,
         0xd4,0xbe,0xe1,0x69,0xde,0xb1,0xd9,0xa2,0xa3,0x83,0xa1,0xf3,0x4f,0x92,0xa7,0x1f,
         0xd8,0x2f,0x15,0x66,0xd4,0x6b,0xa2,0x81,0x31,0x41,0x7f,0xf5,0xbd,0x88,0xce,0xc8,
         0x9d,0x43,0xab,0x9f,0x44,0x2c,0x26,0xcf,0x84,0x73,0xbf,0x20,0xb7,0xc6,0x95,0x97,
         0x61,0xfd,0xb4,0x23,0xba,0x7e,0xd0,0x02,0x9b,0x3d,0x38,0x06,0x00,0xd4,0x4f,0x97},
        /*TST_Qinv*/
        {0xbd,0x13,0x03,0xa6,0x79,0x8b,0x99,0x4f,0xd0,0xab,0x3f,0xf0,0x23,0x9a,0xbe,0xda,
         0x2b,0xa1,0x7f,0xda,0xb9,0xbc,0xc5,0x43,0x3b,0xfc,0x18,0x6b,0x70,0x9c,0x9c,0xab,
         0x30,0x85,0x67,0x71,0x8e,0x44,0x04,0x4a,0x7e,0xbd,0x52,0xe6,0x8d,0x38,0x22,0xd0,
         0x62,0x87,0x73,0x52,0x26,0x31,0xdb,0x55,0xbf,0x53,0xc8,0x94,0xa5,0x45,0x8c,0xe5,
         0x1c,0xea,0x01,0xdd,0xab,0xb7,0x6a,0xb6,0x85,0xda,0x79,0xb4,0x1a,0x40,0x9c,0x24,
         0xc0,0xf8,0xe4,0x8a,0x1a,0x6a,0xd6,0x04,0x74,0xfe,0xd6,0x4e,0x73,0x1a,0x5e,0x40,
         0x63,0x62,0x2a,0x9f,0x77,0xaf,0xfc,0xcb,0x1a,0x8a,0x2a,0xbd,0x98,0x84,0x52,0xb9,
         0xb5,0x49,0x30,0x61,0x4b,0xd3,0x87,0x05,0xaa,0xa8,0x8e,0x6f,0x8b,0x53,0xcb,0xd3},
        /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_hash_SHA1*/
        {0xe4,0x8e,0xbf,0x67,0xe0,0xa0,0x2a,0xfe,0x14,0x71,0x60,0x6f,0x8f,0x4d,0xd4,0xee,
         0x16,0xf4,0xfe,0x7f},
        /*TST_input_hash_MD5*/
        {0xd4,0x22,0x19,0x30,0x15,0x2a,0xa2,0x54,0x81,0xc7,0x5f,0x9a,0xf8,0xce,0x9a,0x45}, 
        /*TST_input_hash_SHA224*/
        {0xc0,0x3d,0x3c,0x30,0xc2,0xa8,0x31,0x5f,0x33,0x7c,0x61,0x8e,0xc5,0xba,0x7c,0x80,
        0xe0,0xb5,0xc4,0x73,0xfe,0x59,0xb9,0xd0,0x6d,0xff,0xab,0x7a},
        /*TST_input_hash_SHA256*/
        {0x4b,0x55,0x8a,0xc5,0xf2,0x7a,0xad,0x4f,0xdd,0x97,0x4c,0x01,0x36,0x13,0x89,0x01,
        0x6a,0xa3,0x37,0x79,0xa8,0x3f,0xc0,0x54,0x2b,0x8e,0x1d,0x28,0xd4,0x53,0x7e,0xd5}, 
        /*TST_input_hash_SHA384*/
        {0x64,0x5b,0x67,0x75,0x8b,0x26,0x5f,0xaf,0x17,0xd7,0x3f,0x58,0xae,0x0b,0xd4,0x98,
        0xa3,0xa8,0xf3,0x3f,0xc9,0x94,0xa2,0x10,0x81,0x00,0xb1,0x0e,0x92,0x57,0xf0,0x4b,
        0x66,0xaf,0x82,0x16,0xe8,0x85,0x16,0x5a,0xa1,0x35,0x27,0x00,0x6f,0x36,0x9e,0x70},
        /*TST_input_hash_SHA512*/
         {0x06,0x9c,0x2d,0x5d,0x4a,0x46,0xbe,0x69,0xa3,0x87,0x66,0x7e,0x8a,0xa6,0x75,0x2e,
         0x74,0x82,0x46,0x6a,0x87,0x16,0xfc,0x14,0x49,0x99,0x28,0xc6,0x01,0xd1,0xeb,0xe3,
         0xb5,0x14,0x85,0x72,0xec,0x01,0xe5,0x56,0x59,0x49,0x3f,0x86,0x95,0x16,0xfc,0x62,
         0xbc,0x4f,0x51,0x5a,0x26,0xc4,0x85,0xa9,0xff,0xa2,0x06,0xc5,0xa5,0x74,0xc4,0x86}, 
        /*TST_output_signiture*/
        {0},
    },  
   
};


SEP_RSA_TestSignVerifyDataStruct SEP_RSA_Acceptance_ExportPrivAndPubKey_TestData[] =
{

	/*  2048 bit key                  */
	/************/    
	{ 
		{"Acceptance test - RSA ExportPrivAndPubKey 16byteData/2048bit key "},
			/*TST_PrivetExponent_D*/
		{0x19,0xd5,0x40,0x04,0x82,0x85,0x9d,0x97,0x1a,0x4f,0x83,0x5e,0x22,0x13,0x1a,0x6f,
		0x02,0xd7,0xb8,0x17,0xef,0x86,0x68,0x8c,0xe2,0x14,0x8b,0xbc,0x24,0xe0,0x64,0xb6,
		0x23,0x6c,0xc7,0x80,0xf3,0xdf,0x70,0x5b,0xac,0x68,0xbb,0xb8,0x74,0x48,0xdd,0x33,
		0x10,0x10,0xc8,0x43,0xb3,0xf3,0x2c,0x00,0x8a,0xf8,0xd0,0xbb,0xc0,0x4b,0xe8,0xae,
		0xcd,0x3e,0x14,0xad,0x4d,0x84,0x96,0x75,0x53,0x3e,0x96,0x6a,0xff,0x5c,0xba,0x85,
		0xe1,0x26,0x7b,0xa3,0xf2,0x4d,0x7e,0x69,0xab,0x96,0x56,0x2f,0x28,0xdb,0xd0,0x72,
		0x0c,0x31,0x7d,0x49,0xfc,0xaf,0x21,0x2c,0x13,0x56,0x0f,0x34,0x71,0x66,0x6c,0x9d,
		0x86,0xf4,0x28,0x19,0x74,0x76,0xe4,0x11,0x92,0xb8,0xef,0xd0,0x87,0xa5,0x86,0x2a,
		0x83,0x30,0xbf,0x15,0xdf,0x36,0xf4,0xe1,0xdc,0x65,0x94,0x66,0xef,0x7a,0xfa,0x6b,
		0xcb,0x59,0x29,0xac,0x4c,0xa0,0x4f,0x12,0xf3,0x4a,0x1e,0x79,0x7f,0x13,0xef,0x12,
		0xd6,0xbf,0xc4,0x95,0xad,0x89,0x03,0x62,0xe9,0x8c,0x2c,0x79,0x48,0xd5,0x4b,0x65,
		0x9a,0xba,0x7b,0x5d,0xbe,0x98,0x59,0x9a,0xed,0x23,0xe6,0x6d,0x7c,0x51,0xc1,0xd6,
		0x72,0x77,0xb2,0x63,0x96,0xbf,0x03,0xf7,0x14,0xb4,0x80,0x29,0x2b,0x64,0xdc,0xf6,
		0x2f,0xe4,0x35,0x09,0xb0,0xf8,0x9c,0x13,0xfa,0x99,0x66,0x1e,0x19,0x0c,0xad,0x6c,
		0xae,0x7e,0xba,0x82,0x77,0x33,0x95,0xf9,0xd3,0xa8,0x83,0xa7,0x73,0x9f,0xb3,0xef,
		0xe5,0xc6,0x7f,0x26,0x82,0xd2,0x26,0xd8,0xa6,0xbe,0x78,0xe5,0x02,0x16,0xa7,0x81},
		/*TST_PublicExponent_E*/
		{0x01,0x00,0x01},
		/*TST_Modulus_N*/
		{0xd7,0xd6,0x06,0x52,0xd9,0x4c,0x1c,0x9c,0xe9,0xa1,0xab,0x97,0x38,0x0b,0x5f,0xc2,
		0x4b,0x27,0x21,0x04,0x4b,0xa9,0x94,0xcc,0x85,0x34,0x04,0x33,0x31,0x9f,0xf8,0x61,
		0x64,0x39,0x46,0x4a,0x42,0x97,0x4f,0x57,0xc0,0x70,0x03,0x2b,0xfe,0x79,0xfa,0x62,
		0x57,0x97,0x50,0x2b,0xbd,0x62,0x8f,0x75,0xd9,0x67,0x1f,0x16,0x9e,0x35,0xd1,0x17,
		0x8f,0xa1,0x06,0x81,0xd5,0x80,0xfa,0x72,0xef,0x8c,0x64,0x0c,0xb8,0x95,0x25,0x07,
		0x8f,0x9c,0xae,0x3a,0x27,0xfe,0x74,0xf1,0x0d,0x72,0x49,0x06,0x1a,0xba,0x76,0x34,
		0x5e,0xa1,0x67,0x1d,0x2d,0x13,0x1e,0xc8,0x67,0x76,0x3a,0x0b,0x3f,0x25,0xa9,0xb5,
		0x2e,0xeb,0xbc,0x09,0xcf,0x2f,0xed,0x7a,0x48,0x24,0xa2,0xb5,0x2e,0x04,0xe3,0xae,
		0x12,0xe1,0x9d,0xc4,0x5d,0x56,0x36,0x76,0x03,0x03,0xb9,0x49,0xee,0x12,0xf5,0x32,
		0x62,0x18,0xea,0x7e,0x74,0x47,0x48,0x97,0x95,0x92,0x3e,0xdb,0x73,0x5e,0xeb,0x22,
		0x37,0xc1,0x63,0xbf,0x44,0x1e,0x5f,0xf3,0x5c,0xcc,0x34,0xaa,0xb8,0x3f,0xaf,0x89,
		0x21,0x0c,0x0c,0x5a,0x93,0xca,0x91,0x34,0x68,0x9a,0x65,0xc4,0x81,0xfe,0x05,0xb8,
		0x99,0x55,0x99,0xd8,0x58,0x18,0x74,0x2a,0xce,0x31,0x7a,0xa3,0xa6,0x60,0xa0,0x72,
		0x65,0xed,0xad,0x95,0x1d,0xf8,0x72,0xb1,0x36,0xdc,0x53,0x2a,0x68,0x7f,0xce,0x82,
		0x4f,0xb1,0xe3,0xef,0x02,0x64,0x4c,0x7e,0xd3,0x57,0x51,0x72,0xe0,0x06,0x3c,0xbd,
		0xce,0x04,0x33,0x9a,0x66,0xa4,0x83,0x29,0x56,0xf3,0xe9,0xec,0xab,0x12,0x9d,0xfd},
		/*TST_P*/
		{0xf9,0xba,0xdf,0xfa,0x9b,0xc2,0xb2,0x45,0xd3,0x2f,0x57,0x8a,0x9e,0x62,0xaa,0x9c,
		0x10,0x11,0xe8,0x04,0x22,0x7d,0xd6,0xd9,0xc5,0x12,0xff,0xdc,0x8e,0x47,0x5a,0x65,
		0x96,0x94,0x94,0x96,0x1b,0xba,0xe0,0x6e,0x1a,0xca,0xb5,0xd3,0x07,0x2e,0x18,0xce,
		0xd8,0x99,0x88,0xf1,0x9b,0xf3,0x00,0xd6,0xc2,0xf7,0x40,0xca,0x81,0x25,0x5b,0x45,
		0xbb,0x42,0xc2,0xb8,0x97,0x46,0xfe,0x2d,0xd2,0xf8,0xed,0x7a,0x2f,0xbc,0x00,0xac,
		0xa8,0x4d,0xf6,0x70,0xe9,0x93,0xf2,0x1f,0x66,0xfa,0x6a,0xf5,0x99,0x8e,0x95,0x3d,
		0x4d,0x58,0x66,0x28,0xd1,0x3b,0x0a,0xcd,0xe0,0x14,0x23,0x18,0x7d,0x81,0xb7,0x93,
		0x28,0xff,0x45,0x3f,0xa2,0xeb,0x04,0x84,0xdd,0x51,0x46,0xb3,0x74,0x4b,0xd7,0x25},
		/*TST_Q*/
		{0xdd,0x41,0x4c,0x63,0x98,0x2a,0x8d,0xf3,0xd5,0x3f,0xcb,0x78,0xf3,0x76,0x01,0x85,
		0x8d,0x86,0x63,0x8e,0x59,0x35,0x48,0xe7,0xa4,0x77,0xe0,0xc1,0x18,0x9c,0x63,0xff,
		0xee,0x80,0xe7,0x00,0xe1,0x6a,0x20,0x39,0x82,0xc9,0x4b,0x7d,0x92,0x91,0x41,0x41,
		0x96,0xe7,0x05,0xaf,0xeb,0xc3,0x74,0x0f,0x9f,0x25,0xf7,0x1c,0x1d,0xda,0x29,0x76,
		0x83,0x46,0x3f,0x52,0xa1,0x02,0xb7,0xf9,0xd3,0x8c,0x76,0xc8,0xbe,0x60,0x77,0xb9,
		0xd5,0x4e,0x18,0x13,0x2b,0x0c,0x7a,0xef,0xd9,0x1b,0x31,0x75,0x74,0xa5,0x08,0xec,
		0x5f,0x0e,0x65,0x0f,0xe4,0xfc,0x70,0xe7,0x12,0xc7,0x2f,0x66,0x06,0xe6,0xf7,0x46,
		0xc9,0x5d,0x04,0xe7,0xf3,0x5a,0x24,0x58,0x0d,0xd5,0x4d,0x14,0x90,0x57,0x7f,0xf9},     
		/*TST_dP*/
		{0xca,0xc4,0xe6,0xaa,0x18,0xa0,0xcc,0x99,0x8f,0x71,0x08,0x36,0xa0,0x85,0xe2,0x9b,
		0x97,0x1c,0xc2,0xf3,0xe0,0x81,0xa6,0xda,0xe9,0x7e,0x94,0xcb,0xa3,0xa6,0xe2,0x0a,
		0x4c,0x6a,0xd5,0xfe,0xd0,0x03,0x3b,0xc9,0x8a,0xed,0x7f,0x17,0x1a,0xe4,0x5d,0xf6,
		0x4d,0xbe,0xd4,0x87,0xc1,0x25,0x5d,0x50,0x03,0xbc,0x39,0x1a,0x74,0x24,0x3d,0xe8,
		0xef,0xb4,0xb4,0x60,0xa7,0x4c,0x58,0x84,0x22,0xa2,0x46,0x48,0x88,0xcb,0xb1,0x0c,
		0x80,0x17,0xd5,0x7b,0x36,0xdd,0x0e,0xa2,0x5a,0xbe,0x07,0xec,0xe5,0x42,0xf5,0x80,
		0x71,0xf5,0xcd,0xf5,0x64,0x75,0xf9,0x3e,0xd2,0xab,0xe7,0x17,0x32,0x89,0x09,0xe2,
		0x6e,0x4e,0x5f,0x0e,0xdd,0x9c,0xcf,0xed,0x85,0xba,0x41,0x9a,0xe2,0x59,0xd6,0x15},
		/*TST_dQ*/
		{0xa9,0x7a,0xf0,0x61,0xc5,0xd8,0xaa,0xfd,0xe1,0x16,0xc9,0xec,0xaf,0x49,0x70,0x66,
		0xf5,0xfe,0xc0,0x59,0xf4,0xd9,0x8d,0x2b,0xeb,0x5e,0xec,0x69,0xdd,0x49,0x46,0x8c,
		0x70,0x0c,0x8b,0x66,0xb0,0x44,0x93,0xc4,0x99,0xfb,0x49,0x79,0x3a,0x01,0x4c,0x24,
		0x4a,0xcc,0x52,0x1d,0xec,0x91,0xbe,0x60,0x8c,0xff,0x0e,0xe7,0x99,0xb2,0x58,0x5a,
		0x70,0xba,0x29,0x9d,0x48,0xba,0x85,0x64,0xb7,0xf8,0x7b,0xb0,0xcf,0xab,0xa3,0x6a,
		0x55,0x0b,0x4a,0x03,0xbc,0xd1,0x05,0x86,0x9e,0x1e,0x67,0x67,0x5a,0x5f,0x64,0x93,
		0x73,0x48,0xda,0x7f,0x2f,0x5f,0x73,0xb8,0x7d,0x38,0xd8,0x84,0xe5,0xba,0x9c,0x25,
		0xbb,0xef,0x25,0xe7,0xeb,0x0f,0xdc,0x91,0x1a,0x9f,0x8e,0x38,0xb7,0x4c,0x5f,0x39},
		/*TST_Qinv*/
		{0xa6,0x1d,0xc0,0xb0,0x32,0x7b,0x00,0x3e,0xa2,0x13,0xbf,0x5a,0x1d,0xc2,0x1b,0xb1,
		0xcb,0x18,0x0d,0x8f,0xae,0x7f,0xb4,0xc1,0x57,0x85,0x8a,0x5b,0x0a,0xdf,0xf3,0x5d,
		0x9c,0xab,0x81,0x43,0x9e,0xf4,0x5e,0x3f,0x5e,0x37,0x85,0x9d,0xb8,0x8a,0x82,0xde,
		0xbf,0x16,0xdc,0x75,0x3b,0x98,0xdc,0x41,0x25,0x3f,0x19,0x89,0x02,0xf2,0xec,0xef,
		0xd8,0x05,0x48,0x5a,0x8c,0x1b,0xbe,0x2d,0x8e,0xef,0x0b,0xe4,0xa9,0x78,0x1f,0x1c,
		0xfc,0xf3,0xd9,0x4c,0xae,0x5e,0x77,0x90,0x31,0xb7,0x16,0xca,0xf0,0xa0,0xea,0x4d,
		0x59,0xc9,0x90,0x04,0x7e,0x1b,0x36,0x86,0x5a,0xca,0xb4,0x0d,0xa3,0xa1,0xb8,0x2d,
		0x68,0x38,0x5f,0xcb,0xae,0x36,0x4f,0x5d,0x55,0x16,0xfd,0xc5,0x2f,0x8b,0xb2,0xec},
		/*TST_KeySize*/
		256*sizeof(DxUint8_t),
		/*TST_DPSize*/
		128*sizeof(DxUint8_t),      
		/*TST_PubExponentSize*/
		3*sizeof(DxUint8_t),
		/*TST_SaltLength*/
		20,       
		/*TST_input_data*/
		{0xa9,0x7a,0xf0,0x61,0xc5,0xd8,0xaa,0xfd,0xe1,0x16,0xc9,0xec,0xaf,0x49,0x70,0x66},
		/*TST_input_dataSize*/
		16*sizeof(DxUint8_t), 
		/*TST_output_signiture*/
		{0},
	},

};
